using System;
using System.IO;
using System.Collections.Generic;
using System.Threading;

namespace Task
{
	class Task
	{
        public class Chain
        {
            public long FirstFilePos, LastFilePos;
            public List<ulong> Numbers= new List<ulong>();
            public List<long> Positions = new List<long>();
            public void Clear()
            {
                FirstFilePos = LastFilePos = 0;
                Numbers.Clear();
                Positions.Clear();
            }
            public Chain()
            {
                Clear();
            }
            public void Copy(Chain c)
            {
                FirstFilePos=c.FirstFilePos;
                LastFilePos=c.LastFilePos;
                Numbers.Clear();
                Positions.Clear();
                Numbers = new List<ulong>(c.Numbers.ToArray());
                Positions = new List<long>(c.Positions.ToArray());
            }
            public void AddChain(Chain c)
            {
                Numbers.AddRange(c.Numbers.ToArray());
                Positions.AddRange(c.Positions.ToArray());
            }
        }
        public struct StartThreadData
        {
            public string FileName;
            public long Offset;
            public long WorkLength;
            public int ThreadID;
        }
        
        public static Chain[] WorkChains;
        public static int[] WorkProgress;
        public static bool StopWork;

		static bool isPrime(ulong num)
		{
            if (num <2 ) return false;
            ulong b=(ulong)Math.Sqrt((double)num);
			for (ulong a=2;a<=b;a++)
				if (num%a==0) 
						return false;
			return true;
		}


        static void FindPrimes(object td)
		{
            string FileName = ((StartThreadData)td).FileName ;
            long Offset = ((StartThreadData)td).Offset;
            long WorkLength = ((StartThreadData)td).WorkLength;
            int ThreadID=((StartThreadData)td).ThreadID;

            FileStream fs = File.Open(FileName, FileMode.Open, FileAccess.Read, FileShare.Read);
            fs.Seek(Offset, SeekOrigin.Begin);
            Chain CurrentChain = new Chain();
            

			ulong uNumber;
			byte[] bsNumber= new byte[6];
			int a,rb,wp=0;
			
            for(;;)
			{
                Thread.Sleep(0);
                if (StopWork) break;
                if (WorkLength!=0)
                    wp = (int)((fs.Position - Offset)*100/WorkLength);
                if (wp < 0) wp = 0;
                if (wp > 100) wp = 100;

                Monitor.Enter(WorkProgress);
                WorkProgress[ThreadID] = wp;
                Monitor.Exit(WorkProgress);
                uNumber = 0;
                if (fs.Position + 6 - Offset > WorkLength) break;
                rb=fs.Read(bsNumber,0,6);
				if (rb!=6) break;
				for (a=1,uNumber+=bsNumber[0];a<6;a++)
				{
					uNumber<<=8;
					uNumber+=bsNumber[a];
				}

                if (isPrime(uNumber))
                {
                    CurrentChain.Numbers.Add(uNumber);
                    CurrentChain.Positions.Add(fs.Position - 6);
                }
			}
            fs.Close();
            Monitor.Enter(WorkChains);
            WorkChains[ThreadID] = CurrentChain;
            Monitor.Exit(WorkChains);
		}
        static Chain FindChain(Chain ch)
        {
            Chain CurrentChain = new Chain();
            Chain BestChain = new Chain();
            for (int CurrentNumber = 0; CurrentNumber <= ch.Numbers.Count; CurrentNumber++)
            {
                if (CurrentNumber != ch.Numbers.Count
                    && (CurrentChain.Numbers.Count == 0 || ch.Numbers[CurrentNumber] > CurrentChain.Numbers[CurrentChain.Numbers.Count - 1])
                    )
                {
                    CurrentChain.Numbers.Add(ch.Numbers[CurrentNumber]);
                    CurrentChain.Positions.Add(ch.Positions[CurrentNumber]);
                }
                else
                {
                    if (BestChain.Numbers.Count == 0
                        || (CurrentChain.Numbers.Count > BestChain.Numbers.Count)
                        || (CurrentChain.Numbers.Count == BestChain.Numbers.Count && CurrentChain.Numbers[0] > BestChain.Numbers[0])
                        )
                    {
                        BestChain.Copy(CurrentChain);
                        BestChain.FirstFilePos = BestChain.Positions[0];
                        BestChain.LastFilePos = BestChain.Positions[BestChain.Positions.Count - 1];
                    }
                    CurrentChain.Clear();
                    if (CurrentNumber != ch.Numbers.Count)
                    {
                        CurrentChain.Numbers.Add(ch.Numbers[CurrentNumber]);
                        CurrentChain.Positions.Add(ch.Positions[CurrentNumber]);
                    }
                }
            }
            return BestChain;
        }
		static void Main(string[] args)
		{
            if (args.Length == 0) Environment.Exit(0);
			string fileName=args[0];

            FileStream f = File.Open(fileName, FileMode.Open, FileAccess.Read, FileShare.Read);
            long FileLength = f.Length;
			long fz=FileLength;
            f.Close();

            Console.Clear();
			string[] fzs=new string[]{"Bytes","KB","MB","GB"};
            int a = 0;
			for (;fz>1024 && a<3;a++,fz/=1024);
			Console.WriteLine("File size = {0} {1}",fz,fzs[a]);
            Console.WriteLine("Press Alt+X to abort.");
            Console.WriteLine();
            Console.WriteLine("(1/2) Finding primes...");

            int ThreadsCount = Environment.ProcessorCount;

            WorkChains= new Chain[ThreadsCount];
            WorkProgress = new int[ThreadsCount];
            Thread[] WorkThreads = new Thread[ThreadsCount];
            long Offset= 0;
            long WorkLength;
            WorkLength = FileLength / ThreadsCount;
            WorkLength += (6 - WorkLength % 6);
            for (int CurrentThread = 0; CurrentThread < ThreadsCount; CurrentThread++)
            {
                StartThreadData td= new StartThreadData();
                td.FileName = fileName;
                td.Offset = Offset;
                td.WorkLength = WorkLength;
                td.ThreadID = CurrentThread;
                WorkThreads[CurrentThread] = new Thread(Task.FindPrimes);
                WorkThreads[CurrentThread].Start(td);
                Offset += WorkLength;
            }
            StopWork=false;
            for (;;)
            {
                Thread.Sleep(200);
                if (Console.KeyAvailable)
                {
                    ConsoleKeyInfo ki = Console.ReadKey(true);
                    if ((ki.Modifiers & ConsoleModifiers.Alt) != 0 && ki.KeyChar.ToString().ToUpper() == "X")
                    {
                        StopWork = true;
                    }
                        
                }
                bool Complete = true;
                for (int CurrentThread = 0; CurrentThread < ThreadsCount; CurrentThread++)
                    if (WorkThreads[CurrentThread].IsAlive) Complete=false;
                Console.SetCursorPosition(0, 5);
                Console.WriteLine("Work progress:");
                Monitor.Enter(WorkProgress);
                for (int CurrentThread = 0; CurrentThread < ThreadsCount; CurrentThread++)
                    Console.WriteLine("Thread {0} - {1}% ", CurrentThread, WorkProgress[CurrentThread]);
                Monitor.Exit(WorkProgress);
                Console.WriteLine();
                if (Complete) break;
            }
			Console.WriteLine("(2/2) Finding best chain...");

            Chain BestChain = new Chain();
            Chain FinalChain = new Chain();
            Chain CurrentChain = new Chain();
            if (!StopWork)
            {
                for (int CurrentThread = 0; CurrentThread < ThreadsCount; CurrentThread++)
                {
                    if (WorkChains[CurrentThread].Numbers.Count != 0)
                        FinalChain.AddChain(WorkChains[CurrentThread]);
                }
                BestChain = FindChain(FinalChain);
            }
            else
            {
                int BestCount=0;
                for (int CurrentThread = 0; CurrentThread < ThreadsCount; CurrentThread++)
                {
                    CurrentChain = FindChain(WorkChains[CurrentThread]);
                    if (CurrentChain.Numbers.Count > BestCount
                        || (BestCount > 0 && CurrentChain.Numbers.Count == BestCount && CurrentChain.Numbers[0] > BestChain.Numbers[0])
                        )
                    {
                        BestChain.Copy(CurrentChain);
                        BestCount = CurrentChain.Numbers.Count;
                    }
                }
                
            }
            
            Console.WriteLine("Complete.");

            if (BestChain.Numbers.Count > 0)
            {
                Console.WriteLine("First = {0} at position {1}", BestChain.Numbers[0], BestChain.FirstFilePos);
                Console.WriteLine("Last = {0} at position {1}", BestChain.Numbers[BestChain.Numbers.Count - 1], BestChain.LastFilePos);
                Console.WriteLine("Numbers count = {0}", BestChain.Numbers.Count);
            }
            else
                Console.WriteLine("Not found");
		}
	}
}
